<?php include('session.php'); ?>
<?php $selectedMenu = "dashboard"; ?>
<?php include('templates/common/menubar.php'); ?>
<?php include('templates/dashboard_menu.php'); ?>
<?php include('templates/common/footer.php'); ?>
<script>
    
    $(document).ready(function () {
        showGraph();
        showAutoCloseTimerMessage();
    });

    var chartOptions = {
       responsive: true,
      
       maintainAspectRatio: false,
       
       hover: {
          mode: "labels"
       },
       scales: {
          x: {
                display: true,
                gridLines: {
                   color: "#f3f3f3",
                   drawTicks: false
                },
                scaleLabel: {
                   display: true,
                   labelString: "Date"
                }
             },
          y: {
                display: true,
                gridLines: {
                   color: "#f3f3f3",
                   drawTicks: false
                },
                scaleLabel: {
                   display: true,
                   labelString: "Value"
                }
             }
          
       },
        interaction: {
            mode: 'index',
            intersect: true,
        },
        plugins:{
            responsive: true,
            legend: {
                position: "top"
            },
            tooltip:{
                position : 'nearest',
            },
            title: {
                display: true,
                text: "Links shown(last 7 days)",
                color: '#9013fe',
                font: {
                    family: 'Poppins',
                    size: 22,
                    weight: 'bold',
                    lineHeight: 1.2,
                },
                padding: {top: 0, left: 0, right: 0, bottom: 0},
            }
        }
    };
    
    function showGraph() {
        $.get("api/getLatestLinkView",
        function (data) {
            //console.log(data);
            var name = [];
            var link1_name = []
            var link2_name = [];

            for (var i in data.data) {
                name.push(data.data[i].createdDate);
                link1_name.push(data.data[i].link1_name);
                link2_name.push(data.data[i].link2_name);
            }
            var chartdata = {
                labels: name,
                datasets: [
                    {
                        label: 'Link 1',
                        fill: true,
                        backgroundColor: '#9013fe31',
                        borderColor: "#9013fe",
                        pointBorderColor: "#9013fe",
                        pointBackgroundColor: "#FFF",
                        pointBorderWidth: 2,
                        pointHoverBorderWidth: 2,
                        pointRadius: 6,
                        lineTension:0.4,
                        stepped: false,
                        data: link1_name
                    },
                    {
                        label: 'Link 2',
                        fill: true,
                        backgroundColor: '#ff525261',
                        borderColor: "#ff5252",
                        pointBorderColor: "#ff5252",
                        pointBackgroundColor: "#FFF",
                        pointBorderWidth: 2,
                        pointHoverBorderWidth: 2,
                        pointRadius: 6,
                        lineTension:0.4,
                        stepped: false,
                        data: link2_name
                    }
                ]
            };

            var graphTargetCTX = $("#graphCanvas");
            var chartConfig = {
                type: "line",
                options: chartOptions,
                data: chartdata
            };
            var barGraph = new Chart(graphTargetCTX, chartConfig);
        });  
    }
    
    function showAutoCloseTimerMessage() {
        if(typeof window.localStorage !== "undefined" && !localStorage.getItem('visited')) {
            // Set visited flag in local storage
            localStorage.setItem('visited', true);
           
            const Toast = Swal.mixin({
			  toast: true,
			  position: 'top-end',
			  showConfirmButton: false,
			  timer: 3000,
			  timerProgressBar: true,
			  didOpen: (toast) => {
				toast.addEventListener('mouseenter', Swal.stopTimer)
				toast.addEventListener('mouseleave', Swal.resumeTimer)
			  }
			})

			Toast.fire({
			  icon: 'success',
              animation: true,
			  title: 'Signed in successfully'
			})
        }
    }

</script>

